#include <algorithm>
#include <iostream>
#include <vector>

struct Offer {
  int idx;
  int weight;
  int value;
  float rating;
} pom;

std::vector<Offer> offers;
bool cmpRating(const Offer &a, const Offer &b) { return a.rating > b.rating; }
bool cmpIndex(const Offer &a, const Offer &b) { return a.idx < b.idx; }

int main() {
  int n, W;
  float epsilon;
  std::cin >> n >> W >> epsilon;

  for (int i = 0, w, v; i < n; i++) {
    pom.idx = i + 1;
    std::cin >> pom.weight >> pom.value;
    pom.rating = (float)pom.value / ((float)pom.weight * 1.3f);
    offers.push_back(pom);
  }
  std::sort(offers.begin(), offers.end(), cmpRating);

  int count = 0;
  int weight = 0;
  auto left = offers.begin();
  std::vector<Offer>::iterator right = offers.begin();
  while (right != offers.end()) {
    int nextWeight = right->weight;
    if (weight + nextWeight > W)
      break;
    weight += nextWeight;
    count++;
    right++;
  }
  std::cout << count << "\n";
  std::vector<Offer> rez;
  for (auto it = left; it != right; it++) {
    rez.push_back(*it);
  }
  std::sort(rez.begin(), rez.end(), cmpIndex);

  for (auto &offer : rez) {
    std::cout << offer.idx << " ";
  }
  return 0;
}